/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRBrowsePanel;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRRegistryManager;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRWorkflowPublishPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class VWWSRRPublishDialog
extends VWModalDialog
implements ActionListener,
Runnable,
ChangeListener {
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private JTabbedPane m_tabbedPanel = null;
    private VWWSRRRegistryManager m_wsrrRegistryManager = null;
    private VWWSRRBrowsePanel m_browsePanel = null;
    private VWWSRRWorkflowPublishPanel m_workflowPublishPanel = null;
    private JPanel m_buttonPanel = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private Thread m_initThread = null;
    private Object m_syncObject = new Object();

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:56:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    public VWWSRRPublishDialog(Frame parent, VWSession session) {
        super(parent);
        this.m_parentFrame = parent;
        this.init(session);
        VWAccessibilityHelper.setAccessibility(this, parent, this.getTitle(), this.getTitle());
    }

    public VWSession getSession() {
        return this.m_session;
    }

    private void init(VWSession session) {
        try {
            this.m_session = session;
            this.initializePanelData();
            this.setupLayout();
            this.m_initThread = new Thread(this);
            this.m_initThread.start();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void initializePanelData() {
        try {
            if (this.m_wsrrRegistryManager == null) {
                this.m_wsrrRegistryManager = new VWWSRRRegistryManager(this.m_session);
            } else {
                this.m_wsrrRegistryManager.setAbortInit(false);
                this.m_wsrrRegistryManager.initData();
            }
            if (this.m_workflowPublishPanel == null) {
                this.m_workflowPublishPanel = new VWWSRRWorkflowPublishPanel(this.m_parentFrame, this.m_session, this.m_wsrrRegistryManager);
            } else {
                this.m_workflowPublishPanel.resetSelectedServicesTableModel();
                this.m_workflowPublishPanel.resetWebServicesWorkflowTableModel();
                this.m_workflowPublishPanel.initData(this.m_wsrrRegistryManager);
            }
            if (this.m_browsePanel == null) {
                this.m_browsePanel = new VWWSRRBrowsePanel(this.m_parentFrame, this.m_session, this.m_wsrrRegistryManager);
            } else {
                this.m_browsePanel.initData(this.m_wsrrRegistryManager);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object = this.m_syncObject;
            synchronized (object) {
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        try {
            Object e = this.m_syncObject;
            synchronized (e) {
                this.m_workflowPublishPanel.initData(this.m_wsrrRegistryManager);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        if (this.m_initThread != null && this.m_initThread.isAlive()) {
            try {
                try {
                    this.m_initThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Object var5_8 = null;
                    this.m_initThread = null;
                }
                Object var5_7 = null;
                this.m_initThread = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.m_initThread = null;
                throw throwable;
            }
        }
    }

    private void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("825, 665");
        if (dim == null) {
            dim = new Dimension(750, 600);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_wsrrPublishDialogTitle);
        VWAccessibilityHelper.setAccessibility(this, null, this.getTitle(), this.getTitle());
        this.m_tabbedPanel = new JTabbedPane();
        this.m_tabbedPanel.addChangeListener(this);
        if (this.m_workflowPublishPanel == null) {
            this.m_workflowPublishPanel = new VWWSRRWorkflowPublishPanel(this.m_parentFrame, this.m_session, this.m_wsrrRegistryManager);
        }
        if (this.m_browsePanel == null) {
            this.m_browsePanel = new VWWSRRBrowsePanel(this.m_parentFrame, this.m_session, this.m_wsrrRegistryManager);
        }
        this.m_tabbedPanel.add(VWResource.s_publishWorkflow, this.m_workflowPublishPanel);
        this.m_tabbedPanel.add(VWResource.s_browseWSRR, this.m_browsePanel);
        VWAccessibilityHelper.setAccessibility(this.m_workflowPublishPanel, this.m_tabbedPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_browsePanel, this.m_tabbedPanel, null, null);
        this.m_buttonPanel = new JPanel();
        this.m_closeButton = new JButton(VWResource.s_close);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_buttonPanel.setLayout(new FlowLayout());
        this.m_buttonPanel.add(this.m_closeButton);
        this.m_buttonPanel.add(this.m_helpButton);
        VWAccessibilityHelper.setAccessibility(this.m_closeButton, this.m_buttonPanel, this.m_closeButton.getText(), this.m_closeButton.getText());
        VWAccessibilityHelper.setAccessibility(this.m_helpButton, this.m_buttonPanel, this.m_helpButton.getText(), this.m_helpButton.getText());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.m_tabbedPanel, "Center");
        panel.add((Component)this.m_buttonPanel, "Last");
        VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, panel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_buttonPanel, panel, null, null);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)panel, "Center");
        VWAccessibilityHelper.setAccessibility(panel, this, null, null);
        this.m_closeButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_closeButton) {
            if (this.m_browsePanel != null && !this.m_browsePanel.onClosePanel()) {
                return;
            }
            if (this.m_wsrrRegistryManager != null) {
                this.m_wsrrRegistryManager.setAbortInit(true);
            }
            this.setVisible(false);
        } else if (source == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc097.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        if (this.m_browsePanel != null && this.m_browsePanel.hasUnpublishedData()) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_closePublishDialogWarning2, VWResource.s_wsrrPublishDialogTitle, 3);
        }
        super.windowClosing(event);
    }

    public void stateChanged(ChangeEvent event) {
        JTabbedPane tabPane;
        Component component;
        Object source = event.getSource();
        if (source instanceof JTabbedPane && (component = (tabPane = (JTabbedPane)source).getSelectedComponent()) instanceof VWWSRRBrowsePanel) {
            VWWSRRBrowsePanel panel = (VWWSRRBrowsePanel)component;
        }
    }
}

